# Changelog

## 1.0.243 - 2026-01-26
- Added Browse image refresh token so category lists stay cached while preview updates land.
- Expanded Home browse recommendations with paging and language goal category inference.
- Added a Reviews heading on Home.

## 1.0.242 - 2026-01-23
- Added topic policy rules/prompts/decision caching to block or warn on generation.
- Added admin controls for topic policy configuration and decision review.

## 1.0.241 - 2026-01-23
- Added per-language topic exclusions so specific grammar decks can be removed and prevented from backfill.

## 1.0.240 - 2026-01-22
- Fixed grammar audit results to include deck topics (no more “Untitled” entries).

## 1.0.239 - 2026-01-22
- Added per-deck grammar audit results with explicit reasons and surfaced them in grammar coverage.

## 1.0.238 - 2026-01-22
- Added deck issue counts and per-domain issue viewing directly in grammar coverage.

## 1.0.237 - 2026-01-22
- Showed grammar deck audit results alongside grammar coverage in Admin.

## 1.0.236 - 2026-01-22
- Audited grammar decks against specific topics (not just domains) and surfaced topic issues in Admin.

## 1.0.235 - 2026-01-22
- Added a unique constraint for grammar audit issues so upserts work reliably.

## 1.0.234 - 2026-01-22
- Added admin controls for grammar support mapping with manual edits.
- Added an AI grammar audit job with issue review actions in Content Ops.

## 1.0.226 - 2026-01-19
- Fixed language deck auto-categorization to avoid treating topics as skills.
- Rebuilt auto-skill category paths to keep topic leaves and insert domain categories consistently.

## 1.0.227 - 2026-01-22
- Prevented domain labels from duplicating the language or skill (e.g., “French Grammar”).

## 1.0.228 - 2026-01-22
- Stopped adding the topic as a category leaf when a domain is present to avoid duplicate deck names.

## 1.0.229 - 2026-01-22
- Removed topic leaves from auto-skill category paths for all skills (Vocabulary/Grammar/etc.).

## 1.0.230 - 2026-01-22
- Hid deck card counts in Browse tiles to free up space.

## 1.0.231 - 2026-01-22
- Reused master preview images across language variants even when a deck-specific preview is missing.

## 1.0.232 - 2026-01-22
- Kept skill-level category covers language-specific while sharing domain-level covers across languages.

## 1.0.233 - 2026-01-22
- Kept deck preview images per language variant unless a preview exists for that deck.

## 1.0.216 - 2026-01-19
- Synced topic advisor generation with Studio-style skill categorization.
- Applied deck image styles to preview hero prompts.

## 1.0.217 - 2026-01-19
- Forced topic advisor runs to use bilingual presets and styles.

## 1.0.218 - 2026-01-19
- Shared Studio deck defaults across Studio/Admin for consistent bilingual generation.

## 1.0.219 - 2026-01-19
- Auto-triggered language backfill even when a master already exists.

## 1.0.220 - 2026-01-19
- Fixed language backfill to reuse existing deck categories and prioritize newest masters.

## 1.0.221 - 2026-01-19
- Synced existing deck categories during language backfill.

## 1.0.222 - 2026-01-19
- Added owner action to delete a master and all language variants.

## 1.0.223 - 2026-01-19
- Always show delete-all-variants in owner deck menu.

## 1.0.224 - 2026-01-19
- Added master lookup by topic when deleting all variants.

## 1.0.225 - 2026-01-19
- Honored explicit skill from category when generating masters and prompts.

## 1.0.215 - 2026-01-19
- Cached deck preview images by master to reuse across language variants.

## 1.0.214 - 2026-01-19
- Shared deck preview image cache across language variants.

## 1.0.213 - 2026-01-19
- Reused cached Browse category and deck lists to avoid unnecessary reloads.

## 1.0.212 - 2026-01-19
- Reused cached Browse categories to avoid unnecessary reloads.

## 1.0.211 - 2026-01-19
- Forced transparent backgrounds for category cover prompts.

## 1.0.210 - 2026-01-19
- Stabilized language backfill categories to reuse the master category path.

## 1.0.209 - 2026-01-19
- Added a backend setting to disable audio generation across Studio and admin runs.

## 1.0.208 - 2026-01-19
- Removed completion snackbars for backend job notices.

## 1.0.207 - 2026-01-19
- Defaulted topic advisor runs to the current language when no category is set.

## 1.0.206 - 2026-01-19
- Added per-suggestion run actions for topic coverage advisor jobs.

## 1.0.205 - 2026-01-19
- Added master deck tables for shared language assets.
- Worker now reuses shared images for bilingual decks when available.

## 1.0.204 - 2026-01-19
- Consolidated multiple generation banners into a tabbed selector.

## 1.0.203 - 2026-01-19
- Cascaded deck deletions to remove dependent copies before the source.

## 1.0.202 - 2026-01-19
- Added an owner-only category action to delete all decks within it.

## 1.0.201 - 2026-01-19
- Added an admin action to reset domain cache by language and skill.
- Made domain prompts favor broader categories.

## 1.0.200 - 2026-01-19
- Prevented stale domains from sticking when re-categorizing bilingual decks.
- Tightened domain language prompts and reduced cross-language matches.

## 1.0.199 - 2026-01-19
- Made the Browse owner actions sheet scrollable on smaller screens.

## 1.0.198 - 2026-01-19
- Avoided repeating the topic as a leaf category when a domain is present.

## 1.0.197 - 2026-01-19
- Added an owner action to re-run deck categorization from Browse.

## 1.0.188 - 2026-01-19
- Added embedding-based domain categorization for deck categories.
- Added category domain storage with similarity matching in Supabase.
- Exposed OpenAI embedding model config in Admin.

## 1.0.187 - 2026-01-19
- Added backend worker concurrency and auto-manage settings in Admin.
- Surfaced worker spec details (CPU/RAM/size) in Admin.
- Added optional JWT bypass for admin functions and extended worker status details.

## 1.0.186 - 2026-01-19
- Limited model pricing subtitles to dropdown entries to prevent overflow.

## 1.0.185 - 2026-01-19
- Standardized model pricing labels with units in Admin dropdowns.

## 1.0.184 - 2026-01-19
- Sorted model dropdowns by price (cheapest to most expensive) by default.

## 1.0.183 - 2026-01-19
- Prevented pricing subtitles from overflowing in model selection fields.

## 1.0.182 - 2026-01-19
- Displayed model pricing as a subtitle in Admin dropdowns.

## 1.0.181 - 2026-01-19
- Added pricing labels to model dropdowns in Admin configuration.

## 1.0.180 - 2026-01-19
- Added a Vision model dropdown in Admin configuration.

## 1.0.179 - 2026-01-19
- Added model dropdowns in Admin based on pricing JSON.

## 1.0.178 - 2026-01-19
- Added owner-editable app configuration panel in Admin.

## 1.0.177 - 2026-01-18
- Added database-backed app configuration overrides for models, pricing, and generation defaults.

## 1.0.176 - 2026-01-18
- Added native auth redirect handling for Supabase email verification and magic links.

## 1.0.175 - 2026-01-17
- Combined Studio generate button with compact token stats.

## 1.0.174 - 2026-01-17
- Reset bilingual learning language to French when switching back from term-definition.

## 1.0.173 - 2026-01-17
- Replaced Studio deck type pills with a preview-card gallery selector.

## 1.0.172 - 2026-01-17
- Updated Studio term-definition decks to auto-categorize and default to the native language.

## 1.0.171 - 2026-01-17
- Added owner-only deck actions in Browse for editing metadata and regenerating previews.

## 1.0.170 - 2026-01-17
- Added AI-selected skill labels into bilingual deck categories during generation.

## 1.0.169 - 2026-01-17
- Removed the Studio “AI ready” badge.

## 1.0.168 - 2026-01-17
- Hid AI providers and Voice/Audio settings for non-owner and non-undercover accounts.

## 1.0.167 - 2026-01-17
- Moved token estimates into a compact pill beside the Generate button in Studio.

## 1.0.166 - 2026-01-17
- Removed the Studio sample topic button and footer ETA line.

## 1.0.165 - 2026-01-17
- Removed Studio skill and batch count controls for bilingual decks and fixed Studio to 12 cards per deck.

## 1.0.164 - 2026-01-17
- Removed Studio difficulty and art style selectors and dropped difficulty from prompts.

## 1.0.163 - 2026-01-17
- Simplified the Studio hero text to only the short description.

## 1.0.162 - 2026-01-17
- Removed the Studio hero eyebrow text.

## 1.0.161 - 2026-01-17
- Removed the Studio beta badge and start button.

## 1.0.160 - 2026-01-17
- Removed Library filter pills for all/due/in progress/shared.

## 1.0.159 - 2026-01-17
- Review header now shows the full category path for the active deck.

## 1.0.158 - 2026-01-17
- Review now advances to the next deck with due cards instead of sticking to a finished deck.

## 1.0.157 - 2026-01-17
- Removed the Library download action from the header.

## 1.0.156 - 2026-01-17
- Removed the Library upload decks action and centered on downloads only.

## 1.0.155 - 2026-01-17
- Library category navigation now shows decks in-place when you reach a leaf category.

## 1.0.154 - 2026-01-17
- Moved the bilingual mode toggle into the Library deck settings menu.

## 1.0.153 - 2026-01-17
- Moved Library deck actions into a settings menu and added inline review control.

## 1.0.152 - 2026-01-17
- Matched Library deck card sizing to the category tile grid.

## 1.0.151 - 2026-01-17
- Fixed Library deck card layout sizing when rendering preview-style cards.

## 1.0.150 - 2026-01-17
- Updated Library deck cards to match the Browse preview style with action controls along the bottom.

## 1.0.138 - 2026-01-14
- Disabled worker auth when configured and avoided JWT failures for worker status.

## 1.0.137 - 2026-01-14
- Added cloud backend controls for user generation and auto-managing the worker.
- Queued backend jobs now refresh decks when they finish.

## 1.0.136 - 2026-01-14
- Added a Library update button to pull in newly added cards from source decks.

## 1.0.135 - 2026-01-14
- Updated app branding text to Decked and refreshed the macOS window name.

## 1.0.134 - 2026-01-14
- Updated Studio header branding and logo to Decked.

## 1.0.133 - 2026-01-14
- Tuned iOS and macOS icons to match Apple rounding and sizing.

## 1.0.132 - 2026-01-14
- Replaced app icons across platforms with the new Decked logo.

## 1.0.131 - 2026-01-14
- Updated the iOS display name to Decked.

## 1.0.130 - 2026-01-14
- Auto-sync new decks to the cloud on creation and after adding cards.

## 1.0.129 - 2026-01-14
- Included your own public decks in Browse results.

## 1.0.128 - 2026-01-14
- Defaulted new generated decks to public visibility.
- Simplified Browse scope filters to Curated, User, or Both.

## 1.0.127 - 2026-01-14
- Replaced manual category entry in Studio with Skill + Topic inputs and auto-built category paths.
- Added curated skill suggestions per deck type to keep decks consistent.

## 1.0.126 - 2026-01-14
- Added smart category suggestions in Studio with auto-category defaults for new decks.
- Normalized category paths for consistent casing and common aliases.

## 1.0.125 - 2026-01-14
- Mirrored bilingual decks now add both directions while keeping deck counts based on unique pairs.
- Updated language pair labels to Learning/Native across Studio and Admin.

## 1.0.124 - 2026-01-14
- Enabled Studio generation by default unless explicitly disabled in env.

## 1.0.123 - 2026-01-14
- Simplified Studio generation to two built-in deck types with curated art styles.

## 1.0.122 - 2026-01-13
- Synced top screens/actions with the main analytics range selector.

## 1.0.121 - 2026-01-13
- Added analytics charts (time-series and duration histograms) to the Admin analytics panel.

## 1.0.120 - 2026-01-13
- Added a 24h/7d/all-time toggle for top screens and top actions in Admin analytics.

## 1.0.119 - 2026-01-13
- Replaced the Admin analytics summary stack with a 24h/7d/all-time tab switcher.

## 1.0.118 - 2026-01-13
- Added an all-time analytics summary in the Admin analytics panel.

## 1.0.114 - 2026-01-13
- Added analytics tracking with Supabase storage and Owner analytics summaries in Admin.

## 1.0.117 - 2026-01-13
- Added full Admin user management actions with activity views and notes.

## 1.0.113 - 2026-01-13
- Updated library deck open view to match the review flashcard layout with tap-to-flip.

## 1.0.111 - 2026-01-12
- Added backend worker queue mode for curated generation with progress shown in the top panel.

## 1.0.110 - 2026-01-10
- Admin AI audit mismatch reasons now render as a structured list with clearer formatting.

## 1.0.109 - 2026-01-10
- Admin AI audits and regenerations now report progress in the global top panel.

## 1.0.108 - 2026-01-10
- Fixed Admin AI image regeneration upserts to include card order metadata.

## 1.0.107 - 2026-01-10
- Admin AI audits now keep mismatch results visible and allow optional regeneration even when not requested.

## 1.0.106 - 2026-01-10
- Image prompts now explicitly forbid text/labels and require the image to depict the term clearly.

## 1.0.105 - 2026-01-10
- Admin AI image audits now accept custom criteria and enforce color-vs-object clarity checks.

## 1.0.104 - 2026-01-10
- Added a two-step approval flow for Admin AI image audits before regenerating mismatches.

## 1.0.103 - 2026-01-10
- Added an Admin AI audit workflow to scan deck images and optionally regenerate mismatches.

## 1.0.102 - 2026-01-10
- Removed the Studio deck preview panel.

## 1.0.101 - 2026-01-10
- Disabled Studio deck generation UI with a Browse redirect message.

## 1.0.100 - 2026-01-10
- Shortened iOS home screen app name to "LinguaMem".

## 1.0.99 - 2026-01-10
- Admin AI can expand curated decks by adding cards or targeting a total count.
- Decks now persist answer language for consistent bilingual expansions.

## 1.0.98 - 2026-01-10
- Curated generation now detects any language under a “Languages” category, not just a fixed list.

## 1.0.97 - 2026-01-10
- Curated generation now prefers category language over default English for bilingual presets.

## 1.0.96 - 2026-01-10
- Admin AI now queues run-progress tasks from create/generate commands and can auto-start generation.

## 1.0.95 - 2026-01-10
- Added preset format rules to keep bilingual noun decks in the correct languages and format.

## 1.0.94 - 2026-01-10
- Admin AI topic additions now preserve explicit category paths.

## 1.0.93 - 2026-01-10
- Admin AI now reports when requested topic additions are already present.

## 1.0.92 - 2026-01-10
- Admin AI can now add topic-plan entries with presets and styles.

## 1.0.91 - 2026-01-10
- Added Admin AI command panel with approval-gated actions.

## 1.0.90 - 2026-01-10
- Enriched curated topic suggestions with dynamic category and generation context.

## 1.0.89 - 2026-01-10
- Curated generation now derives language from category when language fields are empty.

## 1.0.88 - 2026-01-10
- Stopped run-progress tasks are now resumable.

## 1.0.87 - 2026-01-10
- Curated generation now skips tasks already marked complete.

## 1.0.86 - 2026-01-10
- Run progress queue is now used for curated generation when populated.

## 1.0.85 - 2026-01-10
- Defaulted Admin preset selection so run-progress details always show preset/style.

## 1.0.84 - 2026-01-10
- Added expandable task details in run progress.

## 1.0.83 - 2026-01-10
- Added run-progress action to category suggestions in Admin.

## 1.0.82 - 2026-01-10
- Made topic suggestion actions more visible in Admin.

## 1.0.81 - 2026-01-10
- Added a quick action to queue topic suggestions into run progress.

## 1.0.80 - 2026-01-10
- Enforced preset selection in topic suggestions with fallback to available presets.

## 1.0.79 - 2026-01-10
- Hardened topic suggestion filtering to stay within the selected category tree.

## 1.0.78 - 2026-01-10
- Added preset-aware topic suggestions with per-topic override syntax in topic plans.

## 1.0.77 - 2026-01-10
- Added category-tree browsing in curated catalog and browse with topic plan integration.

## 1.0.76 - 2026-01-10
- Included preset context in curated category AI suggestions.

## 1.0.75 - 2026-01-10
- Collapsed curated and browse categories into hierarchical trees.

## 1.0.74 - 2026-01-10
- Added preset catalog sync plus AI-assisted preset suggestions.

## 1.0.73 - 2026-01-10
- Added curated catalog category AI with assessment and hierarchy suggestions.

## 1.0.72 - 2026-01-10
- Added curated catalog category editing with subcategory path updates.

## 1.0.71 - 2026-01-10
- Added hierarchical category paths for curated decks with subcategory editing.

## 1.0.70 - 2026-01-10
- Reordered Admin settings flow with collapsible presets/basics and advanced-only toggles.

## 1.0.69 - 2026-01-09
- Reorganized Admin settings flow with collapsible subsections for inputs, styles, and suggestions.

## 1.0.68 - 2026-01-09
- Reordered Admin suggestions to follow core generation settings.

## 1.0.67 - 2026-01-09
- Combined Admin topic planning with generation settings and added collapsible panels.

## 1.0.66 - 2026-01-09
- Unified preset form definitions across Studio and Admin generation settings.

## 1.0.65 - 2026-01-09
- Combined Topic Plan and Topic Suggestions into a single Admin panel.

## 1.0.64 - 2026-01-09
- Simplified Admin topic planning by removing range inputs.

## 1.0.63 - 2026-01-09
- Made Featured sizing dynamic to prevent preview overflow on small screens.

## 1.0.62 - 2026-01-07
- Stabilized Featured preview layout to avoid image overlap.

## 1.0.61 - 2026-01-07
- Added a mobile pill dropdown bar for Browse filters.

## 1.0.60 - 2026-01-07
- Centered the Library upload action and removed the download button.

## 1.0.59 - 2026-01-07
- Replaced Library filter chips with a single pill bar.

## 1.0.58 - 2026-01-07
- Compressed Library stat cards into a compact horizontal row on mobile.

## 1.0.57 - 2026-01-07
- Reduced spacing between the review header and utility bar.

## 1.0.56 - 2026-01-07
- Tightened review panel spacing to reduce mobile scrolling.

## 1.0.55 - 2026-01-07
- Tightened review spacing between the hint and rating prompt.

## 1.0.54 - 2026-01-07
- Switched review rating buttons to a compact pill control.

## 1.0.53 - 2026-01-07
- Centered the review tap-to-reveal hint.

## 1.0.52 - 2026-01-07
- Removed the review navigation arrows.

## 1.0.51 - 2026-01-07
- Removed the review reveal-answer button.

## 1.0.50 - 2026-01-07
- Hid the review audio status when no card audio is available.

## 1.0.49 - 2026-01-07
- Updated review hint copy for tap-to-reveal.

## 1.0.48 - 2026-01-07
- Condensed review header controls into a single compact line.

## 1.0.47 - 2026-01-07
- Grouped Library decks by expandable categories.

## 1.0.46 - 2026-01-07
- Stabilized Featured preview sizing to avoid internal gaps.

## 1.0.45 - 2026-01-07
- Made Featured and New & notable sections phone-friendly.

## 1.0.44 - 2026-01-07
- Reworked Browse layout for phone screens to avoid overflow.

## 1.0.43 - 2026-01-07
- Compressed Library deck actions into a single horizontal strip.

## 1.0.42 - 2026-01-07
- Removed the next-due summary tile from review.

## 1.0.41 - 2026-01-07
- Placed audio control on the flashcard and aligned navigation with reveal.

## 1.0.40 - 2026-01-07
- Moved review navigation arrows onto the audio control row.

## 1.0.39 - 2026-01-07
- Simplified review navigation to icon-only arrows.

## 1.0.38 - 2026-01-07
- Removed the image preview control from the review session.

## 1.0.37 - 2026-01-07
- Removed the review session queue preview panel.

## 1.0.36 - 2026-01-07
- Simplified the review flashcard layout and removed extra chrome.

## 1.0.35 - 2026-01-07
- Replaced the review card panel with the reusable animated flashcard view.

## 1.0.34 - 2026-01-07
- Randomized featured decks by category on each Browse visit.

## 1.0.33 - 2026-01-07
- Prevented Browse card action labels from wrapping.

## 1.0.32 - 2026-01-07
- Hardened Browse horizontal cards against header overflow.

## 1.0.31 - 2026-01-07
- Made Browse horizontal cards layout-driven to prevent overflow.

## 1.0.30 - 2026-01-07
- Added curated deck deletion controls to the Admin catalog.

## 1.0.29 - 2026-01-07
- Added shimmer placeholders for browse preview imagery while loading.

## 1.0.28 - 2026-01-07
- Prefetched preview cards and images for all browse decks.

## 1.0.27 - 2026-01-07
- Refactored Browse layout and featured carousel sizing to prevent card overflow.

## 1.0.26 - 2026-01-07
- Tuned the featured carousel sizing to avoid content clipping.

## 1.0.25 - 2026-01-07
- Added category support for curated decks and browse filtering.
- Added AI topic suggestions for curated categories in Admin.

## 1.0.24 - 2026-01-07
- Added preset selection and art style toggles to the Admin curated generator.

## 1.0.23 - 2026-01-07
- Added an owner-only Admin page for curated deck generation with progress tracking.

## 1.0.22 - 2026-01-07
- Show the tutorial every time a demo user signs in.

## 1.0.21 - 2026-01-07
- Added demo build mode with demo login and first-time walkthrough.
- Added demo build workflows for macOS and iOS TestFlight uploads.

## 1.0.20 - 2026-01-07
- Simplified the Studio hero copy and removed the feature/steps promos.

## 1.0.19 - 2026-01-06
- Added preset style toggle cards and bilingual language controls for nouns decks.

## 1.0.18 - 2026-01-06
- Added a preset system with a nouns bilingual starter preset.

## 1.0.17 - 2026-01-06
- Warned when audio generation is skipped due to ElevenLabs errors.

## 1.0.16 - 2026-01-06
- Skipped audio generation failures so decks still save without audio.

## 1.0.15 - 2026-01-06
- Added owner-only prompt logs for generated decks.

## 1.0.14 - 2026-01-06
- Added a PDF preview flow before export.

## 1.0.13 - 2026-01-06
- Updated full-card PDF layout with centered prompt/image/answer typography.

## 1.0.12 - 2026-01-06
- Improved PDF grid layouts so images remain visible on compact pages.

## 1.0.11 - 2026-01-06
- Added PDF export layout and content options (grid layouts and terms-only mode).

## 1.0.10 - 2026-01-06
- Embedded Unicode-capable fonts for PDF export to avoid missing glyphs.

## 1.0.9 - 2026-01-06
- Added a save dialog to choose the PDF export location.

## 1.0.8 - 2026-01-06
- Adjusted PDF export save locations for sandboxed macOS debug builds.

## 1.0.7 - 2026-01-06
- Added a PDF export flow for decks with a modular builder layout.

## 1.0.149 - 2026-01-13
- Removed the Clear filters button from Browse.

## 1.0.148 - 2026-01-13
- Placed the download icon on the same row as the deck title and card count in Browse tiles.

## 1.0.147 - 2026-01-13
- Compacted Browse deck tiles so the preview image takes more space and library state uses an icon.

## 1.0.146 - 2026-01-13
- Added gradient backdrops behind deck preview images to avoid transparent backgrounds.

## 1.0.145 - 2026-01-13
- Added an Admin backend queue panel to inspect queued/running jobs with request/progress details.

## 1.0.144 - 2026-01-13
- Suppressed backend job banners for deck preview generation.

## 1.0.143 - 2026-01-13
- Moved deck preview generation to the cloud worker and queued preview jobs from Browse/Admin/deck uploads.

## 1.0.142 - 2026-01-13
- Improved deck preview generation to avoid long-loading placeholders while previews generate.

## 1.0.141 - 2026-01-13
- Added an admin action to backfill AI hero previews for decks.

## 1.0.140 - 2026-01-13
- Added AI-generated hero preview images for decks in Browse, stored once per deck in Supabase.

## 1.0.189 - 2026-01-19
- Added domain chips to Browse and Library deck tiles.
- Added admin backfill action and worker support for category domains.

## 1.0.190 - 2026-01-19
- Added cancel controls for backend jobs from the generation banner.
- Added backend cancel RPC for generation jobs.

## 1.0.191 - 2026-01-19
- Fixed domain backfill to process legacy decks without auto-skill settings.

## 1.0.192 - 2026-01-19
- Improved domain backfill progress reporting and error surfacing.

## 1.0.193 - 2026-01-19
- Fixed domain backfill updates for databases without decks.updated_at.

## 1.0.194 - 2026-01-19
- Enforced native-language domain labels for bilingual decks.

## 1.0.195 - 2026-01-19
- Ensured domain matching uses native-language labels for bilingual decks.

## 1.0.196 - 2026-01-19
- Added owner editing and delete actions for Browse decks.

## 1.0.6 - 2026-01-06
- Added a settings action to clear downloaded deck storage.

## 1.0.5 - 2026-01-06
- Persisted local deck library storage for non-web builds.

## 1.0.4 - 2026-01-06
- Disabled macOS app sandbox for release builds to allow Sparkle installer to launch.

## 1.0.3 - 2026-01-05
- Added owner-only update diagnostics for Sparkle installer failures.

## 1.0.2 - 2026-01-05
- Added an owner-only force update action for macOS Sparkle checks.

## 1.0.1 - 2026-01-05
- Added macOS Sparkle update checks from Settings.
- Fixed Sparkle feed configuration and appcast generation for release uploads.
- Updated blob upload tooling to overwrite latest release artifacts.
- Added owner admin panel with user list and Undercover Boss mode.
